import { StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";

export default styles = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(20),
    },
    subCont: {
        backgroundColor: "#2C2C2C",
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        borderRadius: 6,
        padding: dpr(18),
        marginTop: dpr(15),
    },
    img: {
        height: dpr(80),
        width: dpr(80),
        borderRadius: 100,
    },
    nameImage: {
        height: dpr(80),
        width: dpr(80),
        backgroundColor: "#FEF8E7",
        borderRadius: 100,
        alignItems: "center",
        justifyContent: "center",
    },
    nameImageText: {
        color: "#DEA512",
        fontFamily: "Roboto_500Medium",
        fontWeight: "bold",
        fontSize: dpr(30),
    },
    sellerBadge: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        backgroundColor: "#FCCA19",
        color: "#2C2C2C",
        width: dpr(80),
        textAlign: "center",
        paddingVertical: 2,
        borderRadius: 1.5,
        marginBottom: dpr(6),
    },
    soldBy: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#898989",
    },
    ownerName: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#FFFFFF",
        marginVertical: dpr(6),
    },
    ratingCont: {
        flexDirection: "row",
        alignItems: "center",
    },
    ratingText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#FFFFFF",
        marginLeft: dpr(8),
        marginRight: dpr(5),
    },
});
